//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "NTAG5Strings.h"
#import "NTAG5_NFC_LIB.h"
#import "ISO15693Command.h"
#import "RFCommands.h"
NS_ASSUME_NONNULL_BEGIN

@interface I2CMasterChannelUseCase: NSObject

+ (I2CMasterChannelUseCase *) sharedInstance;

/*!
 *@abstract   First it is needed to configure the KW41Z combosensor, select standby mode. Then change to
 *work in hybrid mode so Accelerometer and Magnetometer are both active at the same time.
 *Also some configuration is added in the Control register and finally the sensor is entered in active state.
 *(Each time a command is sent, a read of ConfigStatus register is done to check the status of the I2C interface)
 **/
- (void) configSensorI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   retrieves the Temperature data
 **/
- (void) getTempI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   retrieves the accelerometer data corresponding to the X-axis
 **/
- (void) getAccelXI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   retrieves the accelerometer data corresponding to the Y-axis
 **/
- (void) getAccelYI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   retrieves the accelerometer data corresponding to the Z-axis
 **/
- (void) getAccelZI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   retrieves the magnetometer data corresponding to the X-axis
 **/
- (void) getMagnetXI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   retrieves the magnetometer data corresponding to the Y-axis
 **/
- (void) getMagnetYI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   retrieves the magnetometer data corresponding to the Z-axis
 **/
- (void) getMagnetZI2CMaster:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   extracts the I2C Master Channel data
 **/
- (void) readData:(void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

/*!
 *@abstract   sends a custom commands
 *@param cmd is the command to be sent
 **/
- (void) sendCustomCommand: (NSString *) cmd cmd: (void (^)(NSData *aData) )success  onFailure : (void(^)(NSError *error))failure;

@end

NS_ASSUME_NONNULL_END
